/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation;

import com.tacz.guns.api.client.animation.AnimationChannelContent;
import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.AnimationListener;
import com.tacz.guns.api.client.animation.AnimationListenerSupplier;
import com.tacz.guns.api.client.animation.AnimationSoundChannelContent;
import com.tacz.guns.api.client.animation.ObjectAnimation;
import com.tacz.guns.api.client.animation.ObjectAnimationChannel;
import com.tacz.guns.api.client.animation.ObjectAnimationSoundChannel;
import com.tacz.guns.api.client.animation.gltf.AccessorModel;
import com.tacz.guns.api.client.animation.gltf.AnimationModel;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.api.client.animation.gltf.NodeModel;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorData;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorFloatData;
import com.tacz.guns.api.client.animation.interpolator.CustomInterpolator;
import com.tacz.guns.api.client.animation.interpolator.InterpolatorUtil;
import com.tacz.guns.client.resource.pojo.animation.bedrock.AnimationBone;
import com.tacz.guns.client.resource.pojo.animation.bedrock.AnimationKeyframes;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimation;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.animation.bedrock.SoundEffectKeyframes;
import com.tacz.guns.util.math.MathUtil;
import it.unimi.dsi.fastutil.doubles.Double2ObjectMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Animations {
    public static AnimationController createControllerFromGltf(@NotNull AnimationStructure structure, @NotNull AnimationListenerSupplier supplier) {
        ArrayList<ObjectAnimation> prototypes = new ArrayList<ObjectAnimation>();
        List<AnimationModel> animationModels = structure.getAnimationModels();
        for (AnimationModel animationModel : animationModels) {
            ObjectAnimation animation = new ObjectAnimation(animationModel.getName());
            List<AnimationModel.Channel> channelModels = animationModel.getChannels();
            for (AnimationModel.Channel channelModel : channelModels) {
                ObjectAnimationChannel channel = new ObjectAnimationChannel(ObjectAnimationChannel.ChannelType.valueOf(channelModel.path().toUpperCase(Locale.ENGLISH)));
                AnimationModel.Sampler sampler = channelModel.sampler();
                AnimationModel.Interpolation interpolation = sampler.interpolation();
                NodeModel nodeModel = channelModel.nodeModel();
                channel.interpolator = channel.type.equals((Object)ObjectAnimationChannel.ChannelType.ROTATION) && interpolation.equals((Object)AnimationModel.Interpolation.LINEAR) ? InterpolatorUtil.fromInterpolation(InterpolatorUtil.InterpolatorType.SLERP) : InterpolatorUtil.fromInterpolation(InterpolatorUtil.InterpolatorType.valueOf(interpolation.name()));
                channel.node = nodeModel.getName();
                AnimationListener animationListener = supplier.supplyListeners(channel.node, channel.type);
                if (animationListener == null) continue;
                float[] inverseValue = animationListener.initialValue();
                if (channel.type == ObjectAnimationChannel.ChannelType.ROTATION) {
                    if (inverseValue.length == 3) {
                        inverseValue = MathUtil.toQuaternion(inverseValue[0], inverseValue[1], inverseValue[2]);
                    }
                    inverseValue = MathUtil.inverseQuaternion(inverseValue);
                } else if (channel.type == ObjectAnimationChannel.ChannelType.TRANSLATION) {
                    inverseValue[0] = -inverseValue[0];
                    inverseValue[1] = -inverseValue[1];
                    inverseValue[2] = -inverseValue[2];
                }
                AccessorModel input = sampler.input();
                AccessorData inputData = input.getAccessorData();
                if (!(inputData instanceof AccessorFloatData)) {
                    throw new IllegalArgumentException("Input data is not an AccessorFloatData, but " + String.valueOf(inputData.getClass()));
                }
                AccessorFloatData inputFloatData = (AccessorFloatData)inputData;
                AccessorModel output = sampler.output();
                AccessorData outputData = output.getAccessorData();
                if (!(outputData instanceof AccessorFloatData)) {
                    throw new IllegalArgumentException("Output data is not an AccessorFloatData, but " + String.valueOf(inputData.getClass()));
                }
                AccessorFloatData outputFloatData = (AccessorFloatData)outputData;
                int numKeyElements = inputFloatData.getNumElements();
                int numValuesElements = outputFloatData.getTotalNumComponents() / numKeyElements;
                float[] keyframeTimeS = new float[numKeyElements];
                float[][] values = new float[numKeyElements][numValuesElements];
                for (int i = 0; i < numKeyElements; ++i) {
                    keyframeTimeS[i] = inputFloatData.get(i);
                    for (int j = 0; j < numValuesElements; ++j) {
                        values[i][j] = outputFloatData.get(i * numValuesElements + j);
                    }
                    if (channel.type == ObjectAnimationChannel.ChannelType.ROTATION) {
                        values[i] = MathUtil.toEulerAngles(values[i]);
                        values[i] = MathUtil.toQuaternion(-values[i][0], -values[i][1], values[i][2]);
                        values[i] = MathUtil.mulQuaternion(inverseValue, values[i]);
                        continue;
                    }
                    if (channel.type != ObjectAnimationChannel.ChannelType.TRANSLATION) continue;
                    values[i][0] = -values[i][0] + inverseValue[0];
                    values[i][1] = -(-values[i][1] + inverseValue[1]);
                    values[i][2] = values[i][2] + inverseValue[2];
                }
                channel.content.keyframeTimeS = keyframeTimeS;
                channel.content.values = values;
                channel.interpolator.compile(channel.content);
                animation.addChannel(channel);
            }
            prototypes.add(animation);
        }
        return new AnimationController(prototypes, supplier);
    }

    public static AnimationController createControllerFromBedrock(BedrockAnimationFile animationFile, AnimationListenerSupplier supplier) {
        return new AnimationController(Animations.createAnimationFromBedrock(animationFile), supplier);
    }

    @NotNull
    public static List<ObjectAnimation> createAnimationFromBedrock(BedrockAnimationFile animationFile) {
        ArrayList<ObjectAnimation> result = new ArrayList<ObjectAnimation>();
        for (Map.Entry<String, BedrockAnimation> animationEntry : animationFile.getAnimations().entrySet()) {
            SoundEffectKeyframes soundEffectKeyframes;
            ObjectAnimation animation = new ObjectAnimation(animationEntry.getKey());
            BedrockAnimation bedrockAnimation = animationEntry.getValue();
            if (bedrockAnimation.getBones() != null) {
                for (Map.Entry<String, AnimationBone> boneEntry : bedrockAnimation.getBones().entrySet()) {
                    AnimationBone bone = boneEntry.getValue();
                    AnimationKeyframes translationKeyframes = bone.getPosition();
                    AnimationKeyframes rotationKeyframes = bone.getRotation();
                    AnimationKeyframes scaleKeyframes = bone.getScale();
                    if (translationKeyframes != null) {
                        ObjectAnimationChannel translationChannel = new ObjectAnimationChannel(ObjectAnimationChannel.ChannelType.TRANSLATION);
                        translationChannel.node = boneEntry.getKey();
                        translationChannel.interpolator = new CustomInterpolator();
                        Animations.writeBedrockTranslation(translationChannel, bone.getPosition());
                        translationChannel.interpolator.compile(translationChannel.content);
                        animation.addChannel(translationChannel);
                    }
                    if (rotationKeyframes != null) {
                        ObjectAnimationChannel rotationChannel = new ObjectAnimationChannel(ObjectAnimationChannel.ChannelType.ROTATION);
                        rotationChannel.node = boneEntry.getKey();
                        rotationChannel.interpolator = new CustomInterpolator();
                        Animations.writeBedrockRotation(rotationChannel, bone.getRotation());
                        rotationChannel.interpolator.compile(rotationChannel.content);
                        animation.addChannel(rotationChannel);
                    }
                    if (scaleKeyframes == null) continue;
                    ObjectAnimationChannel scaleChannel = new ObjectAnimationChannel(ObjectAnimationChannel.ChannelType.SCALE);
                    scaleChannel.node = boneEntry.getKey();
                    scaleChannel.interpolator = new CustomInterpolator();
                    Animations.writeBedrockScale(scaleChannel, bone.getScale());
                    scaleChannel.interpolator.compile(scaleChannel.content);
                    animation.addChannel(scaleChannel);
                }
            }
            if ((soundEffectKeyframes = bedrockAnimation.getSoundEffects()) != null) {
                ObjectAnimationSoundChannel soundChannel = new ObjectAnimationSoundChannel();
                soundChannel.content = new AnimationSoundChannelContent();
                int keyframeNum = soundEffectKeyframes.getKeyframes().size();
                soundChannel.content.keyframeTimeS = new double[keyframeNum];
                soundChannel.content.keyframeSoundName = new class_2960[keyframeNum];
                int i = 0;
                for (Map.Entry entry : soundEffectKeyframes.getKeyframes().double2ObjectEntrySet()) {
                    soundChannel.content.keyframeTimeS[i] = (Double)entry.getKey();
                    soundChannel.content.keyframeSoundName[i] = (class_2960)entry.getValue();
                    ++i;
                }
                animation.setSoundChannel(soundChannel);
            }
            result.add(animation);
        }
        return result;
    }

    private static void writeBedrockTranslation(ObjectAnimationChannel animationChannel, AnimationKeyframes keyframes) {
        Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe> keyframesMap = keyframes.getKeyframes();
        animationChannel.content.keyframeTimeS = new float[keyframesMap.size()];
        animationChannel.content.values = new float[keyframesMap.size()][];
        animationChannel.content.lerpModes = new AnimationChannelContent.LerpMode[keyframesMap.size()];
        int index = 0;
        for (Double2ObjectMap.Entry entry : keyframesMap.double2ObjectEntrySet()) {
            animationChannel.content.keyframeTimeS[index] = (float)entry.getDoubleKey();
            AnimationKeyframes.Keyframe keyframe = (AnimationKeyframes.Keyframe)entry.getValue();
            if (keyframe.pre() != null || keyframe.post() != null) {
                if (keyframe.pre() != null && keyframe.post() != null) {
                    animationChannel.content.values[index] = new float[6];
                    pre = new Vector3f((Vector3fc)keyframe.pre());
                    Vector3f post = new Vector3f((Vector3fc)keyframe.post());
                    pre.mul(0.0625f, 0.0625f, 0.0625f);
                    post.mul(0.0625f, 0.0625f, 0.0625f);
                    Animations.readVector3fToArray(animationChannel.content.values[index], pre, 0);
                    Animations.readVector3fToArray(animationChannel.content.values[index], post, 3);
                } else if (keyframe.pre() != null) {
                    animationChannel.content.values[index] = new float[3];
                    pre = new Vector3f((Vector3fc)keyframe.pre());
                    pre.mul(0.0625f, 0.0625f, 0.0625f);
                    Animations.readVector3fToArray(animationChannel.content.values[index], pre, 0);
                } else {
                    animationChannel.content.values[index] = new float[3];
                    Vector3f post = new Vector3f((Vector3fc)keyframe.post());
                    post.mul(0.0625f, 0.0625f, 0.0625f);
                    Animations.readVector3fToArray(animationChannel.content.values[index], post, 0);
                }
            } else if (keyframe.data() != null) {
                animationChannel.content.values[index] = new float[3];
                Vector3f data = new Vector3f((Vector3fc)keyframe.data());
                data.mul(0.0625f, 0.0625f, 0.0625f);
                Animations.readVector3fToArray(animationChannel.content.values[index], data, 0);
            }
            String lerpModeName = keyframe.lerpMode();
            if (lerpModeName != null) {
                try {
                    animationChannel.content.lerpModes[index] = AnimationChannelContent.LerpMode.valueOf(lerpModeName.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    animationChannel.content.lerpModes[index] = AnimationChannelContent.LerpMode.LINEAR;
                }
            } else {
                animationChannel.content.lerpModes[index] = AnimationChannelContent.LerpMode.LINEAR;
            }
            ++index;
        }
    }

    private static void writeBedrockRotation(ObjectAnimationChannel animationChannel, AnimationKeyframes keyframes) {
        Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe> keyframesMap = keyframes.getKeyframes();
        animationChannel.content.keyframeTimeS = new float[keyframesMap.size()];
        animationChannel.content.values = new float[keyframesMap.size()][];
        animationChannel.content.lerpModes = new AnimationChannelContent.LerpMode[keyframesMap.size()];
        int index = 0;
        for (Double2ObjectMap.Entry entry : keyframesMap.double2ObjectEntrySet()) {
            animationChannel.content.keyframeTimeS[index] = (float)entry.getDoubleKey();
            AnimationKeyframes.Keyframe keyframe = (AnimationKeyframes.Keyframe)entry.getValue();
            if (keyframe.pre() != null || keyframe.post() != null) {
                if (keyframe.pre() != null && keyframe.post() != null) {
                    animationChannel.content.values[index] = new float[6];
                    pre = new Vector3f((Vector3fc)keyframe.pre());
                    Vector3f post = new Vector3f((Vector3fc)keyframe.post());
                    Animations.toAngle(pre);
                    Animations.toAngle(post);
                    animationChannel.content.values[index][0] = pre.x();
                    animationChannel.content.values[index][1] = pre.y();
                    animationChannel.content.values[index][2] = pre.z();
                    animationChannel.content.values[index][3] = post.x();
                    animationChannel.content.values[index][4] = post.y();
                    animationChannel.content.values[index][5] = post.z();
                } else if (keyframe.pre() != null) {
                    animationChannel.content.values[index] = new float[3];
                    pre = new Vector3f((Vector3fc)keyframe.pre());
                    Animations.toAngle(pre);
                    animationChannel.content.values[index][0] = pre.x();
                    animationChannel.content.values[index][1] = pre.y();
                    animationChannel.content.values[index][2] = pre.z();
                } else {
                    animationChannel.content.values[index] = new float[3];
                    Vector3f post = new Vector3f((Vector3fc)keyframe.post());
                    Animations.toAngle(post);
                    animationChannel.content.values[index][0] = post.x();
                    animationChannel.content.values[index][1] = post.y();
                    animationChannel.content.values[index][2] = post.z();
                }
            } else if (keyframe.data() != null) {
                animationChannel.content.values[index] = new float[3];
                Vector3f data = new Vector3f((Vector3fc)keyframe.data());
                Animations.toAngle(data);
                animationChannel.content.values[index][0] = data.x();
                animationChannel.content.values[index][1] = data.y();
                animationChannel.content.values[index][2] = data.z();
            }
            String lerpModeName = keyframe.lerpMode();
            animationChannel.content.lerpModes[index] = lerpModeName != null ? (lerpModeName.equals(AnimationChannelContent.LerpMode.CATMULLROM.name().toLowerCase()) ? AnimationChannelContent.LerpMode.CATMULLROM : AnimationChannelContent.LerpMode.LINEAR) : AnimationChannelContent.LerpMode.LINEAR;
            ++index;
        }
    }

    private static void writeBedrockScale(ObjectAnimationChannel animationChannel, AnimationKeyframes keyframes) {
        Double2ObjectRBTreeMap<AnimationKeyframes.Keyframe> keyframesMap = keyframes.getKeyframes();
        animationChannel.content.keyframeTimeS = new float[keyframesMap.size()];
        animationChannel.content.values = new float[keyframesMap.size()][];
        animationChannel.content.lerpModes = new AnimationChannelContent.LerpMode[keyframesMap.size()];
        int index = 0;
        for (Double2ObjectMap.Entry entry : keyframesMap.double2ObjectEntrySet()) {
            animationChannel.content.keyframeTimeS[index] = (float)entry.getDoubleKey();
            AnimationKeyframes.Keyframe keyframe = (AnimationKeyframes.Keyframe)entry.getValue();
            if (keyframe.pre() != null || keyframe.post() != null) {
                if (keyframe.pre() != null && keyframe.post() != null) {
                    animationChannel.content.values[index] = new float[6];
                    pre = keyframe.pre();
                    Vector3f post = keyframe.post();
                    Animations.readVector3fToArray(animationChannel.content.values[index], pre, 0);
                    Animations.readVector3fToArray(animationChannel.content.values[index], post, 3);
                } else if (keyframe.pre() != null) {
                    animationChannel.content.values[index] = new float[3];
                    pre = keyframe.pre();
                    Animations.readVector3fToArray(animationChannel.content.values[index], pre, 0);
                } else {
                    animationChannel.content.values[index] = new float[3];
                    Vector3f post = keyframe.post();
                    Animations.readVector3fToArray(animationChannel.content.values[index], post, 0);
                }
            } else if (keyframe.data() != null) {
                animationChannel.content.values[index] = new float[3];
                Vector3f data = keyframe.data();
                Animations.readVector3fToArray(animationChannel.content.values[index], data, 0);
            }
            String lerpModeName = keyframe.lerpMode();
            if (lerpModeName != null) {
                try {
                    animationChannel.content.lerpModes[index] = AnimationChannelContent.LerpMode.valueOf(lerpModeName.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    animationChannel.content.lerpModes[index] = AnimationChannelContent.LerpMode.LINEAR;
                }
            } else {
                animationChannel.content.lerpModes[index] = AnimationChannelContent.LerpMode.LINEAR;
            }
            ++index;
        }
    }

    private static void toAngle(Vector3f vector3f) {
        vector3f.set((float)Math.toRadians(vector3f.x()), (float)Math.toRadians(vector3f.y()), (float)Math.toRadians(vector3f.z()));
    }

    private static void readVector3fToArray(float[] array, Vector3f vector3f, int offset) {
        array[offset] = vector3f.x();
        array[offset + 1] = vector3f.y();
        array[offset + 2] = vector3f.z();
    }
}

